from typing import List;
import csv,logging,os,shutil,sys,time;
from pyFiles import config;
from pyFiles import logging_utilities as lgul;

# ------------------------------------------------------------------------------#
def get_input_data(file_name) -> List:
    logger.info(lgul.getSepLine());

    with open(file_name,'r',newline='',encoding='utf8') as fp:
        my_reader=csv.reader(fp,delimiter="|");
        data_list=[];
        nb_elems=0; # Wird beim Lesen der ersten Zeile gesetzt!
        nb_row=0;   # Zeilenzähler
        try:
            for brow in my_reader:
                nb_row=nb_row+1;

                # Bestimmen der Zahl der Zeilenelemente aus der Kopfzeile
                if nb_row==1: nb_elems=len(brow);

                row=[col.strip(' "') for col in brow];
                lg_row=len(row);

                # Überlesen der Kopfzeile / der auskommentierten Zeilen
                if row[0]=='#': continue;

                # Test auf die Zahl der Elemente in der Zeile
                if lg_row != nb_elems:
                    str1="Diese Zeile enthält keine verwertbaren Daten!";
                    logger.warning(f"Zeile der Eingabedatei {nb_row}: {row}{sbr}{str1}");
                    continue;
                # end if

                data_list.append(row[1:lg_row]);
            # end for

            if len(data_list)==0:
                str1=": Die Eingabedatei enthält keine verwertbaren Daten!";
                logger.error(f"'{input_file}'{str1}");
                sys.exit();
            # end if

        except Exception as e:
            str1="}Beim Lesen der Eingabedatei ist eine Ausnahme aufgetreten - ";
            logger.error(f"'{input_file}':{sbr}{str1}{e}!");
            sys.exit();
        # end try
    # end with

    return data_list;
# end get_input_data

# ------------------------------------------------------------------------------#
def recover_and_purge(foto_dir_path: str)-> int:
    logger.info(f"Foto-Ordner:{sbr}'{foto_dir_path}'");

    nb_files: int=0;
    for dir_file_name in os.listdir(foto_dir_path):

        if not dir_file_name.lower().endswith(".jpg.orig"):
            continue;  # nur JPG/jpg.orig-Dateien

        foto_name=dir_file_name.removesuffix('.orig');
        backup_path=os.path.join(foto_dir_path,dir_file_name);
        foto_path=os.path.join(foto_dir_path,foto_name);

        if os.path.exists(foto_path):
            os.remove(foto_path);

        shutil.copy2(backup_path,foto_path);
        os.remove(backup_path);
        nb_files=nb_files+1;

        str1="Die originale jpg-Datei wurde wieder hergestellt!";
        logger.info(f"'{foto_name}':{sbr}{str1}");
    # end for
    return nb_files;
# end def recover_and_purge

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    # --------------------------------------------------------------------------#
    # --------------------------------------------------------------------------#

    with_console: bool=not config.with_IDE;
    script_name=os.path.basename(sys.argv[0]);
    if len(sys.argv)==2:
        inp: str=sys.argv[1];
        inp=inp.strip().lower();
        if (inp=='true'): with_console=True;
    # end if

    log_filename=config.log_filename;
    log_file_path= os.getcwd();
    log_file_path=os.path.join(log_file_path,log_filename);

    logging.basicConfig(
        level=logging.INFO,
        format="[%(levelname)s] %(message)s",
        handlers=[
            logging.FileHandler(log_file_path),
            logging.StreamHandler()]);

    logger=logging.getLogger('__name__');
    sbr: str='\n\t\t  ';

    # --------------------------------------------------------------------------#
    localTime=time.strftime("%d.%m.%Y um %H:%M:%S Uhr");
    logger.info(lgul.getSepLine(ch='*'))
    logger.info(lgul.getSepLine());
    logger.info(f"Logging-Zeitstempel:{sbr}'{localTime}'");
    logger.info(f"Skript-Name:{sbr}'{script_name}'");
    logger.info(lgul.getSepLine(nl=1))

    # --------------------------------------------------------------------------#
    if with_console:
        str1="\nWollen sie wirklich das Skript ausführen?\n";
        str2="   Eingabe 'j' für ja und 'n' für nein \n --->:";
        sprompt=str1+str2;
        answer=input(sprompt);
        answer=answer.strip().lower();

        if answer!='j':
            str3="Die Ausführung des Skriptes wurde vom Nutzer abgebrochen!";
            logger.info(lgul.getSepLine());
            logger.info(lgul.getSepLine());
            logger.warning(str3);
            logger.info(lgul.getSepLine());
            logger.info(lgul.getSepLine(ch='*',nl=1));
            sys.exit(str3);
        # end if
    # end if

    # --------------------------------------------------------------------------#
    input_file=config.csv_input_filename;
    data_list: List=get_input_data(input_file);

    nb_jobs=0;
    for row in data_list:
        (gpx_file,gpx_dir_path,foto_dir_path,tz_tag,ift_offset)=row;

        if not os.path.isdir(foto_dir_path):
            str1="Das Verzeichnis wird nicht gefunden!";
            logger.error(f"'{foto_dir_path}':{sbr}{str1}");
            sys.exit();

        # -----------------------------------------------------------------------#
        logger.info(f"Foto-Ordner:{sbr}'{foto_dir_path}'");
        logger.info(lgul.getSepLine(ch='-'));
        # -----------------------------------------------------------------------#


        nb_files=recover_and_purge(foto_dir_path);

        logger.info(lgul.getSepLine(ch='-'));
        logger.info(f"Es wurden {nb_files} Foto wieder hergestellt!");
        logger.info(lgul.getSepLine(nl=1))
        logger.info(lgul.getSepLine());

        nb_jobs=nb_jobs+1;
    # end for

    logger.info(f"Es wurden {nb_jobs} Foto-Verzeichnisse ausgewertet!");
    logger.info(lgul.getSepLine());
    logger.info(lgul.getSepLine(ch='*',nl=1));

    if with_console:
        input("\nUm das Skript zu beenden und die Konsole zu schließen,"
              "\ndrücken sie bitte die Returntaste der Tastatur!\n-->:");
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#