from typing import Tuple;
import logging,os,sys;
from datetime import datetime,timedelta;
from zoneinfo import ZoneInfo;
from pyFiles import jpg_exif_handling as eh;
from pyFiles import datetime_utilities as dtul;
from pyFiles import logging_utilities as logutils;

# ------------------------------------------------------------------------------#
logger=logging.getLogger('__name__');
sbr: str='\n\t\t  ';

# ------------------------------------------------------------------------------#
def to_target_tz_dt(dt: datetime,target_tz_info: str) -> datetime:
    return dt.astimezone(ZoneInfo(target_tz_info));
# def to_target_tz_dt

type Locdata_Type=Tuple[float,float,float];

def write_loc_and_time_data_to_foto\
                (dir_foto_path: str,
                 fotoname: str,
                 locData: Locdata_Type,
                 fotoTime: datetime,
                 tz_info: str,
                 ft_offset: timedelta):

    (Lat,Long,Alti)=locData;
    str1="Die berechneten Ortsdaten sind:";
    logger.info(f"'{fotoname}: '{sbr}{str1}{sbr}Breite, Länge: {Lat:6f}, {Long:6f}");

    foto_path=os.path.join(dir_foto_path,fotoname);
    try:
        jpeg_bytes=eh.read_jpeg_bytes(foto_path);
        exif_dict=eh.load_exif(jpeg_bytes);

        eh.apply_gps(exif_dict,locData);
        # Schreibt global in exif_dict!

        if (ft_offset != dtul.Null_Offset):
            # Die Aufnahmezeit in UTC wurde bereits um den Zeitversatz veschoben,
            # sie muss noch in die lokale Zeitzone des Fotos konvertiert werden.
            foto_time_local_tz=to_target_tz_dt(fotoTime,tz_info)

            eh.apply_time(exif_dict,foto_time_local_tz);

            str1="Der Aufnahmezeitstempel des Fotos wurde geändert in:";
            str2: str=logutils.put_dt(foto_time_local_tz,1);
            logger.info(f"'{fotoname}:{sbr}'{str1}{sbr}'{str2}'");
        # end if

        eh.write_exif_lossless(foto_path,exif_dict);

        return True; # TOBEDONE
    except Exception as e:
        logger.error(f"'{fotoname}':{sbr}Eine Ausnahme ist aufgetreten - {e}");
        sys.exit();
    # end try
# end def add_loc_and_time_data_to_foto

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    print('\n# Beginning write_loc_and_time_data_to_foto.py ...\n');
    # --------------------------------------------------------------------------#

    print('\n# Finished write_loc_and_time_data_to_foto.py.\n');
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#