from typing import Dict,Tuple;
import logging,os,shutil,sys;
from datetime import datetime,timedelta;
from pyFiles import logging_utilities as logutils;
from pyFiles import datetime_utilities as dtutils;
from exif import Image as exifImage;

# ------------------------------------------------------------------------------#

logger=logging.getLogger('__name__');
sbr: str='\n\t\t  ';
# ------------------------------------------------------------------------------#

def get_foto_datetime(imagepath) -> Tuple[str,str] | None:
    try:
        with open(imagepath,"rb") as img_file:
            img=exifImage(img_file);

        if img.has_exif:
            oto_test_ok=img.get('offset_time_original')
            offset_time_original: str=('' if (oto_test_ok is None) else oto_test_ok);
            return (img.datetime_original,offset_time_original);
        else:
            return None;
        # end if

    except Exception as e:
        logger.error(f"'{imagepath}':{sbr} Eine Ausnahme ist aufgetreten - {e}");
        sys.exit();
    # end try
# end def get_foto_datetime

def has_gps_data(imagepath) -> bool:
    try:
        with open(imagepath,"rb") as img_file:
            img=exifImage(img_file);

        if img.has_exif and img.get('_gps_ifd_pointer'):
            return img.get('gps_latitude') is not None;
        else:
            return False;
        # end if

    except Exception as e:
        logger.error(f"'{imagepath}':{sbr}Eine Ausnahme ist aufgetreten - {e}");
        sys.exit();
    # end try
# end def has_gps_data

# ------------------------------------------------------------------------------#

type_datetime_interval=Tuple[datetime,datetime];

def is_in_timeinterval(dt: datetime,tiv: type_datetime_interval) -> bool:
    return (dt>=tiv[0]) and dt<=tiv[1];

# ------------------------------------------------------------------------------#

type_foto_dt_data=Dict[str,datetime];

def get_datetimes_of_fotos(dirpath: str,
                           tz_info: str,
                           ft_offset: timedelta)-> type_foto_dt_data | None:

    restore_from_orig_backup: bool=True;
    if restore_from_orig_backup:
        for backup_name in os.listdir(dirpath):
            if not backup_name.lower().endswith(".jpg.orig"):
                continue;  # nur JPG/jpg.orig-Dateien

            foto_name=backup_name.removesuffix('.orig');
            foto_path=os.path.join(dirpath,foto_name);

            if os.path.exists(foto_path):
                os.remove(foto_path);

            backup_path=os.path.join(dirpath,backup_name);
            shutil.copy2(backup_path,foto_path);
            str1="Das Foto wurde der Backup-Datei entnommen";
            str2="und würde für die Verortung wiederverwendet!";
            logger.info(f"'{foto_name}':{sbr}{str1}{sbr}{str2}");
        # end for
    # end if

    foto_times_data_utc: type_foto_dt_data={};

    for fotoname in os.listdir(dirpath):
        datei_path=os.path.join(dirpath,fotoname);

        if not fotoname.lower().endswith(".jpg"):
            continue;  # nur JPG/jpg-Dateien

        datetime_data=get_foto_datetime(datei_path);
        if datetime_data is None:
            logger.warning(f"'{fotoname}':{sbr}Das Foto hat keine Exif-Daten!");
            continue;
        else:
            (sdt,offset_time_original)=datetime_data;
            # sdt heißt stringdatetime
        # end if;

        if has_gps_data(datei_path):
            logger.info(f"'{fotoname}'{sbr} Das Foto hat bereits gps-Daten!");
            continue;
        else:
            logger.info(f"'{fotoname}':{sbr}Das Foto hat KEINE gps-Daten!");
        # end if

        if not sdt:
            logger.warning(f"'{fotoname}':{sbr}Das Foto hat kein Aufnahmedatum!");
            continue;
        else:
            foto_datetime_local_tz=dtutils.to_foto_tz_dt(sdt,tz_info);

            foto_datetime_utc=dtutils.from_local_str_to_utc(sdt,tz_info);
            # Die Fotoaufnahmezeit in UTC in ein dictionary speichern
            foto_times_data_utc[fotoname]=foto_datetime_utc;

            str1="Der Aufnahmezeitstempel des Fotos ist:";
            str2: str=logutils.put_dt(foto_datetime_local_tz,1);
            str3: str=logutils.put_dt(foto_datetime_utc,2);
            logger.info(f"'{fotoname}':{sbr}{str1}{sbr}'{str2}'{sbr}'{str3}'");

            if (ft_offset!=dtutils.Null_Offset):
                str1="Die zeitverschobene Aufnahmezeit des Fotos ist:";
                str2: str=logutils.put_dt(foto_datetime_utc+ft_offset,2);
                logger.info(f"'{fotoname}':{sbr}{str1}{sbr}'{str2}'");
            # end if

            if (offset_time_original != ''):
                str1="Die 'OffsetTimeOriginal' des Fotos ist:";
                logger.info(f"'{fotoname}':{sbr}{str1}{sbr}'{offset_time_original}'");
        # end if
    # end for

    if len(foto_times_data_utc)>0:
        if (ft_offset != dtutils.Null_Offset):
            foto_times_data_utc.update({k:(v+ft_offset) for k,v in foto_times_data_utc.items()});
        # end if
        return foto_times_data_utc;
    else:
        return None;
    # end if
# end def get_datetimes_of_fotos

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    print('\n# Beginning get_datetimes_of_fotos.py ...\n');
    # --------------------------------------------------------------------------#

    print('\n# Finished get_datetimes_of_fotos.py.\n');
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#