import logging,re,sys;
from datetime import datetime,timedelta;
from zoneinfo import ZoneInfo;

# ------------------------------------------------------------------------------#
logger=logging.getLogger('__name__');
sbr: str='\n\t\t  ';

# ------------------------------------------------------------------------------#
def pretty_timedelta(td: timedelta)->str:
    if td.days >= 0:
        return f'+({td!s})';
    return f'-({-td!s})';
# end def pretty_timedelta

# ------------------------------------------------------------------------------#
def test_timeoffset(sft_offset: str)->bool:
    pattern=r"([+-])?\(([0-9]+):([0-9]+):([0-9]+)\)";
    try:
        m=re.match(pattern,sft_offset);
        b0=sft_offset==m.group(0);
        if b0:
            hr,mn,sc=map(int,list(m.group(2,3,4)));
            b2=(0<=hr); b3=(0<=mn<=59); b4=(0<=sc<=59);
            return (b2 and b3 and b4);
        else:
            return False;
        # end if
    except Exception:
        return False;
    # end try
# end def test_timeoffset

# ------------------------------------------------------------------------------#
def get_timeoffset(sft_offset: str)->timedelta:
    pattern=r"([ +-])?\(([0-9]+):([0-9]+):([0-9]+)\)";
    try:
        m=re.match(pattern,sft_offset);
        # Vorzeichen des Offsets
        svz=m.group(1);
        vz: int=(-1 if svz=='-' else +1);
        # Zeitdaten
        hr,mn,sc=map(int,list(m.group(2,3,4)));
        return (vz*timedelta(hours=hr,minutes=mn,seconds=sc));

    except Exception as ex:
        logger.error(f"Eingabeformat des Zeitversatzes ist:{sbr}+(hh:mm:ss) oder -(hh:mm:ss)");
        sys.exit();
    # end try
# end def get_timeoffset

# ------------------------------------------------------------------------------#
sNull_Offset="+(0:0:0)";
Null_Offset=get_timeoffset(sNull_Offset);

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
sformat="%Y:%m:%d %H:%M:%S";

def to_foto_tz_dt(sdt: str,tz_info: str) -> datetime:
    local_tz=ZoneInfo(tz_info);
    dt=datetime.strptime(sdt,sformat);
    return dt.replace(tzinfo=local_tz);
# end def to_foto_tz_dt

def to_utc_dt(dt: datetime) -> datetime:
    return dt.astimezone(ZoneInfo("UTC"));

def from_local_str_to_utc(sdt: str,tz_info: str) -> datetime:
    return to_utc_dt(to_foto_tz_dt(sdt,tz_info));

def to_target_tz_dt(dt: datetime,target_tz_info: str) -> datetime:
    return dt.astimezone(ZoneInfo(target_tz_info));

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    print('\n# Beginning datetime_utilities.py ...\n');
    # --------------------------------------------------------------------------#

    print('\n# Finished datetime_utilities.py.\n');
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#