import logging,os;
from datetime import datetime;
from pyFiles import extract_fotolocdata_from_gpxfile as extractor ;
from pyFiles import get_datetimes_of_fotos as dtgetter;
from pyFiles import write_loc_and_time_data_to_foto as lctm_adder;
from pyFiles import logging_utilities as logutils;
from pyFiles import datetime_utilities as dtul;
from pyFiles import datetime_utilities as dtutils;

# ------------------------------------------------------------------------------#
logger=logging.getLogger('__name__');
sbr: str='\n\t\t  ';

# ------------------------------------------------------------------------------#

def data_adder(gpxFile: str,
               gpxDirPath: str,
               fotos_dir_path: str,
               tz_info: str,
               sft_offset: str,
               analyse_only: bool)->int:

    gpx_file_path=os.path.join(gpxDirPath,gpxFile);

    (trk_name,trk_fdata)=extractor.extract_gpx_data(gpx_file_path);
    track_dt_interval=extractor.get_timeinterval(trk_fdata);

    dt_intv_1=track_dt_interval[0];
    dt_intv_2=track_dt_interval[1];

    str1: str=logutils.put_dt(dt_intv_1,2);
    str2: str=logutils.put_dt(dt_intv_2,2);
    logger.info(f"Das Zeitintervall der Trackdatei ist:{sbr}('{str1}',{sbr} '{str2}')");

    ft_offset=dtutils.get_timeoffset(sft_offset);

    foto_times_data_utc: dtgetter.type_foto_dt_data | None\
        =dtgetter.get_datetimes_of_fotos(fotos_dir_path,tz_info,ft_offset);

    if foto_times_data_utc is None:
        okFiles=0;
        return okFiles;
    # end if

    no_track_fotos={};
    no_track_fotos=[k for k,v in foto_times_data_utc.items()
                  if (not dtgetter.is_in_timeinterval(v,track_dt_interval))];

    for key in no_track_fotos:
        if (sft_offset == dtul.sNull_Offset):
            str1=f"Die originale Aufnahmezeit des Fotos liegt{sbr}außerhalb des Trackzeitraumes!";
            logger.warning(f"'{key}':{sbr}{str1}");
        else:
            str1=f"Die zeitverschobene Aufnahmezeit des Fotos liegt{sbr}außerhalb des Trackzeitraumes!";
            logger.warning(f"'{key}':{sbr}{str1}");
        # end if
        del foto_times_data_utc[key];
    # end for

    # --------------------------------------------------------------------------#
    if len(foto_times_data_utc)==0:
        okFiles=0;
        return okFiles;
    # end if

    foto_locations={};
    for fotoname,foto_dt in foto_times_data_utc.items():
        (tp1data,tp2data)=extractor.extract_foto_locdata_from_gpxfile(trk_fdata,foto_dt);
        locdata=extractor.determine_foto_locdata(tp1data,tp2data,foto_dt);
        foto_locations[fotoname]=locdata;
    # end for

    if analyse_only:
        return len(foto_locations);

    if len(foto_locations)>0:
        nok_files: int=0;
        for k,v in foto_locations.items():
            fotoTime: datetime=foto_times_data_utc[k];
            success=lctm_adder.write_loc_and_time_data_to_foto(fotos_dir_path,
                                                               k,v,
                                                               fotoTime,tz_info,ft_offset);
            # k => key=fotoname, v => value=locData
            if success:
                logger.info(f"'{k}':{sbr}Die Ortsdaten wurden zum Original hinzugefügt!");
            else:
                nok_files=nok_files+1;
                str1="Die Ortsdaten konnten NICHT zum Original hinzugefügt werden!";
                logger.warning(f"'{k}':{sbr}{str1}");
            # end if
        # end for

        okFiles=len(foto_locations)-nok_files;
        return okFiles;
    else:
        okFiles=0;
        return okFiles;
    # end if
# end def

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    print('\n# Beginning add_data_to_fotos_for_1_track.py ...\n');
    # --------------------------------------------------------------------------#
    # --------------------------------------------------------------------------#

    print('\n# Finished add_data_to_fotos_for_1_track.py.\n');
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#