from typing import Final,List;
import csv;
import time;
import logging;
import os,sys;
from pyFiles import time_zone_data as tzd;
from pyFiles import add_data_to_fotos_for_one_track as data2fotos;
from pyFiles import datetime_utilities as dtul;
from pyFiles import config;
from pyFiles import logging_utilities as lgul;
# ------------------------------------------------------------------------------#

def get_input_data(file_name) -> List:
    logger=logging.getLogger('__name__');
    logger.info(lgul.getSepLine());

    with open(file_name,'r',newline='',encoding='utf8') as fp:
        my_reader=csv.reader(fp,delimiter="|");
        data_list=[];
        nb_elems=0; # Wird beim Lesen der ersten Zeile gesetzt!
        nb_row=0;   # Zeilenzähler
        try:
            for brow in my_reader:
                nb_row=nb_row+1;

                # Bestimmen der Zahl der Zeilenelemente aus der Kopfzeile
                if nb_row==1: nb_elems=len(brow);

                row=[col.strip(' "') for col in brow];
                lg_row=len(row);

                # Überlesen der Kopfzeile / der auskommentierten Zeilen
                if row[0]=='#':
                    continue;

                # Test auf die Zahl der Elemente in der Zeile
                if lg_row != nb_elems:
                    logger.warning(f"Zeile der Eingabedatei {nb_row}: {row}{sbr}Diese Zeile enthält keine verwertbaren Daten!");
                    continue;
                # end if
                data_list.append(row[1:lg_row]);
            # end for

            if len(data_list)==0:
                logger.error(f"'{input_file}': Die Eingabedatei enthält keine verwertbaren Daten!");
                sys.exit();
            # end if

        except Exception as e:
            logger.error(f"'{input_file}':{sbr}Beim Lesen der Eingabedatei ist eine Ausnahme aufgetreten - {e}!");
            sys.exit();
        # end try
    # end with

    return data_list;
# end get_input_data

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
if __name__=='__main__':
    # --------------------------------------------------------------------------#
    # --------------------------------------------------------------------------#
    with_console: bool=not config.with_IDE;
    script_name=os.path.basename(sys.argv[0]);
    if len(sys.argv)==2:
        inp: str=sys.argv[1];
        inp=inp.strip().lower();
        if (inp=='true'): with_console=True;
    # end if

    analyse_only: Final=True;

    # --------------------------------------------------------------------------#

    log_filename=config.log_filename;
    log_file_path= os.getcwd();
    log_file_path=os.path.join(log_file_path,log_filename);

    logging.basicConfig(
        level=logging.INFO,
        format="[%(levelname)s] %(message)s",
        handlers=[
            logging.FileHandler(log_file_path),
            logging.StreamHandler()]);

    logger=logging.getLogger('__name__');
    sbr: str='\n\t\t  ';

    # --------------------------------------------------------------------------#
    localTime=time.strftime("%d.%m.%Y um %H:%M:%S Uhr");
    logger.info(lgul.getSepLine(ch='*'))
    logger.info(lgul.getSepLine());
    logger.info(f"Logging-Zeitstempel:{sbr}'{localTime}'");
    logger.info(f"Skript-Name:{sbr}'{script_name}'");

    # --------------------------------------------------------------------------#
    if with_console:
        str1="\nWollen sie wirklich das Skript ausführen?\n";
        str2="   Eingabe 'j' für ja und 'n' für nein \n --->:";
        sprompt=str1+str2;
        answer=input(sprompt);
        answer=answer.strip().lower();

        if answer!='j':
            str3="Die Ausführung des Skriptes wurde vom Nutzer abgebrochen!";
            logger.info(lgul.getSepLine());
            logger.info(lgul.getSepLine());
            logger.warning(str3);
            logger.info(lgul.getSepLine());
            logger.info(lgul.getSepLine(ch='*',nl=1));
            sys.exit(str3);
        # end if
    # end if

    # --------------------------------------------------------------------------#
    input_file=config.csv_input_filename;
    data_list: List=get_input_data(input_file);

    nb_jobs=0;
    gpx_set=set();
    for row in data_list:
        (gpx_file,gpx_dir_path,foto_dir_path,tz_tag,ift_offset)=row;

        gpx_file_path=os.path.join(gpx_dir_path,gpx_file);
        if not os.path.isfile(gpx_file_path):
            logger.error(f"'{gpx_file_path}':{sbr}Die Datei wird nicht gefunden!");
            sys.exit();
        gpx_set.add(gpx_file);

        if not os.path.isdir(foto_dir_path):
            str1="Das Verzeichnis wird nicht gefunden!";
            logger.error(f"'{foto_dir_path}':{sbr}{str1}");
            sys.exit();

        if ift_offset != '':
            if dtul.test_timeoffset(ift_offset):
                sft_offset=ift_offset;
            else:
                str1="Eingabeformat des Zeitversatzes ist:";
                logger.error(f"{str1}{sbr}+(hh:mm:ss) oder -(hh:mm:ss)");
                sys.exit();
            # end if
        else:
            sft_offset=dtul.sNull_Offset;
        # end if

        tz_info: str='';
        if (tz_tag==''):
            mez_tag='EuBl';
            tz_info=tzd.time_zones[mez_tag];
        else:
            try:
                tz_info=tzd.time_zones[tz_tag];
            except KeyError:
                str1="Die Zeitzonenkennung wird nicht in 'time_zone_data.py' gefunden!";
                logger.error(f"{tz_tag}:{sbr}{str1}");
                sys.exit();
            # end try
        # end if

        # -----------------------------------------------------------------------#
        logger.info(f"Track-Datei-Name:{sbr}'{gpx_file}'");
        logger.info(f"Track-Datei-Ordner:{sbr}'{gpx_dir_path}'");
        logger.info(f"Foto-Ordner:{sbr}'{foto_dir_path}'");
        logger.info(f"Zeitzonen-Kennung für den Aufnahmeort:{sbr}'({tz_info})'");
        if (sft_offset != dtul.sNull_Offset):
            logger.info(f"Zeitversatz für die Aufnahmezeiten der Fotos:{sbr}'{ift_offset}'");
        logger.info(lgul.getSepLine(ch='-'));

        # --------------------------------------------------------------------------#
        okFiles=data2fotos.data_adder(gpx_file,gpx_dir_path,foto_dir_path,tz_info,sft_offset,analyse_only);

        logger.info(lgul.getSepLine(ch='-'));
        if analyse_only:
            logger.info(f"Ortsdaten könnten {okFiles} Fotos hinzugefügt werden!");
        else:
            logger.info(f"Ortsdaten wurden zu {okFiles} Fotos hinzugefügt!");
        # end if
        logger.info(lgul.getSepLine(nl=1))
        logger.info(lgul.getSepLine());

        nb_jobs=nb_jobs+1;
    # end for

    nb_gpx=len(gpx_set);
    logger.info(lgul.getSepLine());
    logger.info(f"Es wurden {nb_gpx} gpx-Dateien{sbr}   für {nb_jobs} Foto-Ordner ausgewertet!");
    logger.info(lgul.getSepLine());
    logger.info(lgul.getSepLine(ch='*',nl=1));

    if with_console:
        input("\nUm das Skript zu beenden und die Konsole zu schließen,"
              "\ndrücken sie bitte die Returntaste der Tastatur!\n-->:");
# end if main
# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#