// ############################################################################
// Ausgabe der Daten

// ############################################################################

function fdpLagrange_Ausgabe(tData,yData)

    etotdata=fetotdata(yData);
    ekindata=fekindata(yData);
    epotdata=fepotdata(yData);

    etot0=etotdata(1); // Gesamtenergie, Konstante der Bewegung
    px_etot=[tBegin;tEnd];

    delta_etot=etotdata-etot0;
    delta_etot0=delta_etot(1);

    // ########################################################################

    my_handle1=scf(1);
    clf(my_handle1,"reset");

    a=gca();
    a.x_label.text = "Zeit [s]";
    a.y_label.text = "Energien [Joule]";

    xgrid(color("lightgrey"));
    xtitle('Doppelpendel - Energieverhalten über die Zeit');

    plot(tData,etotdata,'red');
    plot(tData,ekindata,'blue');
    plot(tData,epotdata,'green');

    py_etot=[etot0;etot0];
    e=xpoly(px_etot,py_etot);
    e.foreground=color('scilabmagenta3');

    legend(['Etot(t)';'Ekin(t)';'Epot(t)';'Etot'],"lower_caption",%f);

    // #########################################################################

    my_handle2=scf(2);
    clf(my_handle2,"reset");
    a=gca();

    a.x_label.text = "Zeit [s]";
    a.y_label.text = "Abweichungen vom physikalischen Wert Etot  [Joule]";

    xgrid(color("lightgrey"));
    xtitle('Doppelpendel - Energieverhalten über die Zeit');

    plot(tData,delta_etot,'red');

    py_etot=[delta_etot0;delta_etot0];
    e=xpoly(px_etot,py_etot);
    e.foreground=color('scilabmagenta3');

    legend(['Etot(t) - Etot';'Etot'],"lower_caption",%f);

    // #########################################################################

    mean_etotdata=mean(etotdata);
    mean_ekindata=mean(ekindata);
    mean_epotdata=mean(epotdata);

    max_etotdata=max(etotdata);
    max_ekindata=max(ekindata);
    max_epotdata=max(epotdata);

    min_etotdata=min(etotdata);
    min_ekindata=min(ekindata);
    min_epotdata=min(epotdata);

    init_etot=etotdata(1);
    init_ekin=ekindata(1);
    init_epot=epotdata(1);
    
    // Zur Kontrolle der Algorithmen
    kart_ekin=fekin_kart(w1_0,w2_0,w1dot_0,w2dot_0);
    kart_epot=fepot_kart(w1_0,w2_0);
    kart_etot=fetot_kart(w1_0,w2_0,w1dot_0,w2dot_0);

    disp('   ');
    disp('---');
    disp('kart_ekin    : '+ string(kart_ekin));
    disp('init_ekin    : '+ string(init_ekin));
    disp('mean_ekindata: '+ string(mean_ekindata));
    disp('max_ekindata : '+ string(max_ekindata));
    disp('min_ekindata : '+ string(min_ekindata));
    disp('---');
    disp('kart_epot    : '+ string(kart_epot));
    disp('init_epot    : '+ string(init_epot));
    disp('mean_epotdata: '+ string(mean_epotdata));
    disp('max_epotdata : '+ string(max_epotdata));
    disp('min_epotdata : '+ string(min_epotdata));
    disp('---');
    disp('kart_etot    : '+ string(kart_etot));
    disp('init_etot    : '+ string(init_etot));
    disp('mean_etotdata: '+ string(mean_etotdata));
    disp('max_etotdata : '+ string(max_etotdata));
    disp('min_etotdata : '+ string(min_etotdata));
    disp('---');

   // disp((etotdata-etot1)/etot1);

endfunction;

// #############################################################################
disp('Geladen: dpLagrange-EnergieAusgaben.sci');
