// #############################################################################

function yData=dpLagrange_Solver(y0,t0,tD)

    // Lagrangesches Differentialgleichungssystem
    function ydot=fdpLagrange(t,y)
        w1=y(1); w2=y(2);
        p1=y(3); p2=y(4);
        wd=fwdot(w1,w2,p1,p2);
        pd=fpdot(w1,w2,p1,p2);
        ydot=wd(1)*[1;0;0;0] ..
            +wd(2)*[0;1;0;0] ..
            +pd(1)*[0;0;1;0] ..
            +pd(2)*[0;0;0;1];
    endfunction;
    
    // Lösung der Differntialgleichungen
    // Scilab-Solver-Methode: 
    // "lsoda solver of package ODEPACK is called by default.
    // It automatically selects between nonstiff predictor-corrector Adams
    // method and stiff Backward Differentiation Formula (BDF) method.
    // It uses nonstiff method initially and dynamically monitors data in
    // order to decide which method to use."
    fdp=fdpLagrange;
    yData=ode(y0,t0,tData,fdp); 
    
    // // Scilab-Solver-Methode: Adaptive Runge-Kutta of order 4 (RK4)
    // yData=ode("rk",y0,t0,tData,fdp);
endfunction;

// #############################################################################
disp('Geladen: dpLagrange-DGLSystem.sci');

