// Algorithmen für das Doppelpendel im Lagrange-Formaismus

// #############################################################################
// Gravitationskonstante

gc=9.81; // [m/s^2]

// #############################################################################
// Abgeleitete Konstanten

mue=m2/(m1+m2);
lbd=l2/l1;
omg=gc/l1;
gmt=0.5*(m1+m2)*l1^2;
gmv=-(m1+m2)*l1*gc;

// #############################################################################
// #############################################################################

function rwdot=fwdot(w1,w2,p1,p2)
    rwdot=[p1,p2];
endfunction;

// #############################################################################

function rA=fA(w1,w2,p1,p2)
    rA(1,1)=1.0;
    rA(1,2)=mue*lbd*cos(w1-w2);
    rA(2,1)=cos(w1-w2);
    rA(2,2)=lbd;
endfunction;

function rb1=fb1(w1,w2,p1,p2)
    rb1=-mue*lbd*sin(w1-w2)*p2^2-omg*sin(w1);
endfunction;

function rb2=fb2(w1,w2,p1,p2)
    rb2=sin(w1-w2)*p1^2-omg*sin(w2);
endfunction;

function rb=fb(w1,w2,p1,p2)
    rb(1)=fb1(w1,w2,p1,p2);
    rb(2)=fb2(w1,w2,p1,p2);
endfunction;

function rpdot=fpdot(w1,w2,p1,p2)
    A=fA(w1,w2,p1,p2);
    b=fb(w1,w2,p1,p2);
    rpdot=A\b;
endfunction;

// #############################################################################
// #############################################################################
disp('Geladen: dpLagrange-DGLAlgorithmen.sci');
