// Umrechnungsfunktion Bogengrad nach Radian
function y=fd2r(x),y=x*%pi/180,endfunction;
    // Umrechnungsfunktion Radian nach Bogengrad
function y=fr2d(x),y=x*180.0/%pi,endfunction;

function rwdot=fwdot(w1,p1);
    rwdot=p1;
endfunction;

function rpdot=fpdot(w1,p1)
    rpdot=(-1)*(gc/l1)*sin(w1);
endfunction

function ydot=fsp(t,y)
    w1=y(1);
    p1=y(2);
    ydot=fwdot(w1,p1)*[1;0] ..
        +fpdot(w1,p1)*[0;1];
endfunction;

gc=9.81;
l1=1.0;
wg=5.0;

wr=fd2r(wg);
xmin=-wr;
xmax=wr;
ymin=-0.5;
ymax=0.5;

xGrid=linspace(xmin,xmax,20);
yGrid=linspace(ymin,ymax,20);

fchamp(fsp,0,xGrid,yGrid);

xlabel('$\theta$',"fontsize",4);
ylabel('$d\theta/dt$',"fontsize",4);

a=gca();
a.margins(3)=0.2;
title(['Einfaches Pendel - Phasenportrait'],"fontsize",4);

t0=0; tmax=10;
t=t0:0.05:tmax;

oldx0=10*xmax; oldy0=10*ymax;
dx=0.1; dy=0.1;

rtol=0.0001;
atol=rtol;

while (%t)
    [b,x0,y0]=xclick();

    if or(b==[2 5 -1000]) then break end;
    if or(b==[0 3]) & xmin<x0 & x0<xmax & ymin<y0 & y0<ymax then
        
        sol=ode([x0;y0],t0,t,rtol,atol,fsp);
        
        xpoly(sol(1,:)',sol(2,:)');
        
        p=gce();
        p.thickness=2;
        p.foreground=5;
        rep=[x0,y0,-1];
        
        while rep(3)==-1 then
            rep=xgetmouse();

            x0=rep(1);
            y0=rep(2);
            
            if (xmin<x0 & x0<xmax & ymin<y0 & y0<ymax) ..
                & (abs(x0-oldx0)>=dx ..
                | abs(y0-oldy0)>=dy) then
                
                sol=ode([x0;y0],t0,t,rtol,atol,fsp);
                
                p.data=[sol(1,:)' sol(2,:)'];
                oldx0=x0;
                oldy0=y0;
            end
        end
    end
end
