// ############################################################################
// Ausgabe der Daten

// ############################################################################

function fDisplayNull()
    null=0;
    px_null=[tBegin;tEnd];
    py_null=[null;null];
    e=xpoly(px_null,py_null);
    e.foreground=color('grey');
endfunction;

function fDisplayLine(yw)
    px_null=[tBegin;tEnd];
    py_null=[yw;yw];
    e=xpoly(px_null,py_null);
    e.thickness=2;
    e.line_style=8;
    e.foreground=color('maroon');
endfunction;

function rw180data=fw180data(yL)
    rw180data=[];
    lg=size(yL,"c");
    for i=1:lg
        w=yL(1,i);
        vp=[cos(w);sin(w)];
        w=atand(vp(2),vp(1));
        rw180data(i)=w;
    end;
endfunction;

// #############################################################################

function fdpLagrange_WinkelAusgaben1(tData,yData)
    w1data=fw180data(yData(1,:));
    w2data=fw180data(yData(2,:));

    max_w1data=max(w1data);
    max_w2data=max(w2data);
    is_big_wdata=(max_w1data > 175.0)| (max_w2data > 175.0);

    my_handle1=scf(1);
    clf(my_handle1,"reset");
    a=gca();
    a.x_label.text = "Zeit [s]";
    a.y_label.text = "Pendelwinkel  [°]";
    
    xgrid(color("lightgrey"));
    tDP='> DP => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                     +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                     +' || '+string(gc) ..
                     +' || '+fng(odeType) ..
                     +' ||';
    xtitle(['Doppelpendel - Pendelwinkel über die Zeit';tDP]);
    plot(tData,w1data,'red');
    plot(tData,w2data,'green');

    legend(["$\theta_1\ (t)$";"$\theta_2\ (t)$"],"lower_caption",%f);
    fDisplayNull();
    if is_big_wdata then
        fDisplayLine(180);
        fDisplayLine(-180);
    end;
endfunction;

// #############################################################################

function fdpLagrange_WinkelAusgaben2(tData,yData1,yData2)
    w1data1=fw180data(yData1(1,:));
    w2data1=fw180data(yData1(2,:));

    w1data2=fw180data(yData2(1,:));
    w2data2=fw180data(yData2(2,:));
    max_w1data2=max(w1data2);
    max_w2data2=max(w2data2);
    is_big_wdata=(max_w1data2 > 175.0)| (max_w2data2 > 175.0);

    my_handle2=scf(2);
    clf(my_handle2,"reset");
    a=gca();
    a.x_label.text = "Zeit [s]";
    a.y_label.text = "Pendelwinkel  [°]";
    
    xgrid(color("lightgrey"));
    tDP1='> DP1 => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                     +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                     +' || '+string(gc) ..
                     +' || '+fng(odeType1) ..
                     +' ||';
    tDP2='> DP2 => || '+string(w1_0g)+' | '+string(w1dot_0g) ..
                     +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                     +' || '+string(gc) ..
                     +' || '+fng(odeType2) ..
                     +' ||';
    xtitle(['Doppelpendel - Pendelwinkel über die Zeit';tDP1;tDP2]);

    plot(tData,w1data1,'red');
    plot(tData,w2data1,'green');

    plot(tData,w1data2,'red:');
    plot(tData,w2data2,'blue:');

    lP11="$P1\ \theta_1\ (t)$";
    lP12="$P1\ \theta_2\ (t)$";
    lP21="$P2\ \theta_1\ (t)$";
    lP22="$P2\ \theta_2\ (t)$";
    legend([lP11;lP12;lP21;lP22],"lower_caption",%f);
    fDisplayNull();
    if is_big_wdata then
        fDisplayLine(180);
        fDisplayLine(-180);
    end;
endfunction;

// #############################################################################

function fdpLagrange_WinkelAusgaben3(tData,yData1,yData2)
    w1data1=fw180data(yData1(1,:));
    w2data1=fw180data(yData1(2,:));

    w1data2=fw180data(yData2(1,:));
    w2data2=fw180data(yData2(2,:));

    max_w1data2=max(w1data2);
    max_w2data2=max(w2data2);
    is_big_wdata=(max_w1data2 > 175.0)| (max_w2data2 > 175.0);

    my_handle3=scf(3);
    clf(my_handle3,"reset");
    a=gca();
    a.x_label.text = "Zeit [s]";
    a.y_label.text = "Pendelwinkel  [°]";
    
    xgrid(color("lightgrey"));
    tDP1='> DP1 => || '+string(w1_0g)+'        | '+string(w1dot_0g) ..
                     +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                     +' || '+string(gc) ..
                     +' || '+fng(odeType) ..
                     +' ||';
    tDP2='> DP2 => || '+string(w1_0g+delta_w1_0g)+' | '+string(w1dot_0g) ..
                     +' || '+string(w2_0g)+' | '+string(w2dot_0g) ..
                     +' || '+string(gc) ..
                     +' || '+fng(odeType) ..
                     +' ||';
    xtitle(['Doppelpendel - Pendelwinkel über die Zeit';tDP1;tDP2]);

    plot(tData,w1data1,'red');
    plot(tData,w2data1,'green');

    plot(tData,w1data2,'red:');
    plot(tData,w2data2,'blue:');

    lP11="$DP1\ \theta_1\ (t)$";
    lP12="$DP1\ \theta_2\ (t)$";
    lP21="$DP2\ \theta_1\ (t)$";
    lP22="$DP2\ \theta_2\ (t)$";
    legend([lP11;lP12;lP21;lP22],"lower_caption",%f);
    fDisplayNull();
    if is_big_wdata then
        fDisplayLine(180);
        fDisplayLine(-180);
    end;
endfunction;

// #############################################################################
disp('Geladen: dpLagrange-WinkelAusgaben.sci');