// #############################################################################

// Pendelparameter
// Längen (l1,l2) und Massem (m1,m2) der Pendel
// Länge in Meter [m] , Masse in Kilogramm [kg]

// Oberes Pendel 1
l1=1.0; m1=1.0;
// Unteres Pendel 2
l2=0.5; m2=0.5;

// #############################################################################
// Gravitationskonstante

gc=9.81; // [m/s^2] 9.81

// #############################################################################
// Anfangsbedingungen für die Differentialgleichnungen

// Auslenkungen (wi_0, i=1,2) und Winkelgeschwindigkeiten (widot_0, i=1,2) 
// der beiden Massen
// Auslenkungen in Bogengrad [°]
// Winkelgeschwindigkeiten in Bogengrad pro Zeiteinheit [°/s]

// Auslenkungen
w1_0g=-90.00; w2_0g=-90.0;

// Winkelgeschwindigkeiten
w1dot_0g=270.0; w2dot_0g=0.0; // w1dot_0=254.0;

// Zeitliche Simulationsdauer
tEnd=20; // Dauer in Zeiteinheiten

// #############################################################################
funcprot(0);
// #############################################################################
// Import sci-Module

pathdir = get_absolute_file_path('Doppelpendel-Lagrange-Energie.sce');
exec(pathdir + 'Module/dpLagrange-DGLAlgorithmen.sci');
exec(pathdir + 'Module/dpLagrange-DGLSystem.sci');
exec(pathdir + 'Module/dpLagrange-EnergieAlgorithmen.sci');
exec(pathdir + 'Module/dpLagrange-EnergieAusgaben.sci');

// #############################################################################

// Umrechnungsfunktion Bogengrad nach Radian
function y=fd2r(x),y=x*%pi/180,endfunction;
    // Umrechnungsfunktion Radian nach Bogengrad
function y=fr2d(x),y=x*180.0/%pi,endfunction;

// #############################################################################

function rng=fng(type)
    rng=type;
    if type=="" then
        rng="<not given>";
    end;
endfunction;

// #############################################################################
// Zeitliche Simulationsdaten

tBegin=0; t0=tBegin;
stepTime=1/50;  // Bilder pro Zeiteinheit
tSteps=(tEnd-tBegin)/stepTime;
tData=linspace(tBegin,tEnd,tSteps);

// Anfangsbedingungen nach Radian konvertieren und als Liste packen
w1_0=fd2r(w1_0g); w2_0=fd2r(w2_0g);
w1dot_0=fd2r(w1dot_0g); w2dot_0=fd2r(w2dot_0g);
y0=[w1_0;w2_0;w1dot_0;w2dot_0];

// #############################################################################
// #############################################################################

// Lösen der lagrangeschen Bewgungsgleichungen
odeType="adams";
yData=dpLagrange_Solver(y0,t0,tData,odeType);

// #############################################################################

// Ausgaben der Energie-Daten
if %T then fdpLagrange_EnergieAusgaben(tData,yData) end;
    
// #############################################################################
disp('Beendet: Doppelpendel-Lagrange-Energie.sce');