from math import pi,sqrt,sin;

# ------------------------------------------------------------------------------#

# UTM / WGS84 Daten
# Scale_On_Central_Meridian=0.9996;
Wgs84_Major_Axis=6378137.000;
Wgs84_Minor_Axis=6356752.3141;

Major_Axis=Wgs84_Major_Axis;
Minor_Axis=Wgs84_Minor_Axis;
E_Squared=(Major_Axis ** 2-Minor_Axis ** 2)/Major_Axis ** 2;
E_Two=E_Squared/(2.0-E_Squared);

def radiusOfCurvature_Gauss(gdeticTheta: float) -> float:
    eth=1.0-E_Squared*sin(gdeticTheta) ** 2;
    eth_q=sqrt(eth);
    beta=eth/(1.0-E_Squared);
    R_N=Major_Axis/eth_q;
    # N for normal
    R_M=R_N/beta;
    # M for Meridian
    return sqrt(R_N*R_M);
    # Geometrischer Mittelwert, Gaußscher Krümmungsradius
# end radiusOfCurvature_N

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#

if __name__=='__main__':
    print('\n# Beginning local_sphere ...\n');

    rd2dg=180.0/pi;
    dg2rd=pi/180.0;

    re_84=(Major_Axis+Minor_Axis)/2.0;

    gdeticTheta_g=48.0;
    gdeticTheta_r=gdeticTheta_g*dg2rd;


    print(gdeticTheta_g);
    print('\nÜber Krümmungsradius');

    reNM=radiusOfCurvature_Gauss(gdeticTheta_r);
    print(re_84,' | ',reNM,' | ',re_84-reNM,' | ', 100.0*(re_84-reNM)/re_84);

    print('\n# Finished local_sphere.\n');
# end if main

# ------------------------------------------------------------------------------#
# ------------------------------------------------------------------------------#
